/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.rcs.conndata;

import com.ibm.hwmca.fw.util.LocalizableText;
import java.io.Serializable;

public class PhoneInfo
implements Serializable,
Comparable {
    private static final long serialVersionUID = 186355896964667979L;
    private String isoCountryCode = "";
    private String isoSubdivisionCode = "";
    private String predefinedNumber = "";
    private String phoneNumber = "";
    private String description = "";
    private boolean multiSubdivision = false;
    private static final String DIALABLE_PHONE_CHARS = "0123456789,";
    public static final String ENTERABLE_PHONE_CHARS = "(-)0123456789";

    public PhoneInfo(String number, String desc, String countryCode, String subdivCode, String predefined) {
        if (countryCode == null) {
            throw new IllegalArgumentException("Null ISO country code specified");
        }
        if (!countryCode.equals("") && countryCode.length() != 2) {
            throw new IllegalArgumentException("Non 2 character ISO country code specified");
        }
        if (subdivCode == null) {
            throw new IllegalArgumentException("Null ISO subdivision code specified");
        }
        if (!subdivCode.equals("") && subdivCode.length() > 3) {
            throw new IllegalArgumentException("Non 1-3 character ISO country code specified");
        }
        if (predefined == null) {
            throw new IllegalArgumentException("Null predefined number specified");
        }
        if (number == null || number.equals("")) {
            throw new IllegalArgumentException("Null or empty phone number specified");
        }
        if (this.description == null) {
            throw new IllegalArgumentException("Null description specified");
        }
        this.phoneNumber = number;
        this.description = desc;
        this.isoCountryCode = countryCode;
        this.isoSubdivisionCode = subdivCode;
        this.predefinedNumber = predefined;
    }

    public static LocalizableText validatePhoneNumber(String number) {
        String RES_MSGS = "com.ibm.hwmca.fw.rcs.outconn.res.OutboundConnMsgs";
        String MSG_FIELD_REQUIRED = "FIELD_REQUIRED";
        String MSG_FIELD_MAY_CONTAIN = "FIELD_MAY_CONTAIN";
        if (number == null || number.trim().equals("")) {
            return new LocalizableText(RES_MSGS, MSG_FIELD_REQUIRED);
        }
        for (int i = 0; i < number.length(); ++i) {
            char thisChar = number.charAt(i);
            if (ENTERABLE_PHONE_CHARS.indexOf(thisChar) != -1) continue;
            Object[] subst = new Object[]{"'(-)0123456789'"};
            return new LocalizableText(RES_MSGS, MSG_FIELD_MAY_CONTAIN, subst);
        }
        return null;
    }

    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public String getDescription() {
        return this.description;
    }

    public String getIsoCountryCode() {
        return this.isoCountryCode;
    }

    public String getIsoSubdivisionCode() {
        return this.isoSubdivisionCode;
    }

    public String getPredefinedNumber() {
        return this.predefinedNumber;
    }

    public void setMultiSubdivision(boolean value) {
        this.multiSubdivision = value;
    }

    public boolean isMultiSubdivision() {
        return this.multiSubdivision;
    }

    public String getDialString() {
        StringBuffer dialString = new StringBuffer();
        for (int i = 0; i < this.phoneNumber.length(); ++i) {
            char thisChar = this.phoneNumber.charAt(i);
            if (DIALABLE_PHONE_CHARS.indexOf(thisChar) == -1) continue;
            dialString.append(String.valueOf(thisChar));
        }
        return dialString.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PhoneInfo)) {
            return false;
        }
        PhoneInfo phoneInfo = (PhoneInfo)obj;
        return this.phoneNumber.equals(phoneInfo.phoneNumber);
    }

    public int hashCode() {
        return this.phoneNumber.hashCode();
    }

    public int compareTo(Object obj) {
        return this.description.compareTo(((PhoneInfo)obj).description);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[PhoneInfo: number=" + this.phoneNumber + ", ");
        sb.append("desc=" + this.description + ", ");
        sb.append("isoCtryCode=" + this.isoCountryCode + ", ");
        sb.append("isoSubdivCode=" + this.isoSubdivisionCode + ", ");
        sb.append("predefNumber=" + this.predefinedNumber + ", ");
        sb.append("isMutliSubdiv=" + this.multiSubdivision + "]");
        return sb.toString();
    }
}

